//------------------------------------------------------------------------------
// File: SpyPuzzle.cs
// Handles spy puzzle mission
// Author: Michael Felice
//------------------------------------------------------------------------------


$SpyPuzzleList = "civA civB civC civD civE";

// SCENARIO CALLBACK FUNCTIONS for Spy Puzzle Mission

// load scenario function (initializes the spy puzzle tasks)
function startSpyPuzzleTasks()
{
   InitializeQuestGui();
   tsStartTask("SpyPuzzle", "SpyPuzzleInit");
   
   // disable build button
   tsEnableCommand(BuildCmdData, false);
      
   // Turn off Behavior
   $AI_MONITORJOB = false;
   $AI_MONITORHOME = false;
   $AI_MONITORHUNGER = false;
}

// quit scenario function (turns off the spy puzzle task)
function quitSpyPuzzleTasks()
{
   
   TaskModifier.strResetVertex("MainmapTasks", "BanditSpyLoad");
   TaskModifier.strMarkVertex("MainmapTasks", "BanditSpyLoad", $TSV_AVAIL);
   //tsActivateVertexes("MainmapTasks", "BanditSpyLoad");
}
function EndSpyPuzzleTasks()
{
   tsEndTask("SpyPuzzle"); 
}


// MAIN SET OF TASKS

// there hero will give the intro for the puzzle
function SpyPuzzleInit::onExit(%vertex)
{
   // set up the base functionality needed to shuffle the characters
   %characters = "";
   %positions = "";
   %count = getWordCount($SpyPuzzleList);
   for (%index = 0; %index < %count; %index++)
   {
      %char = getWord($SpyPuzzleList, %index);
      %characters[%index] = %char;
      %positions[%index] = %char.position;
      %rotations[%index] = %char.rotation;
   }
   
   // shuffle the civilian locations around
   for (%index = %count - 1; %index >= 0; %index--)
   {
      %swap = getRandom(0, %index);
      %newPosition = %positions[%index];
      %posX = getWord(%newPosition, 0);
      %posY = getWord(%newPosition, 1);
      %characters[%swap].setPosition(%posX, %posY);
      %characters[%swap].rotation = %rotations[%index];
      
      // once the position has been set, set up the unused charcter
      // (the one that was not selected to be included next time)
      %characters[%swap] = %characters[%index];
   }
   
   tsSendTaskPopUpDlg("ID_TASKNAME_SPYPUZZLE", "id_spypuzzle_intro",
      $TaskButton::Okay, "HeroCharacter", "id_spypuzzle_intro");
}

// the sheriff gives the rules for the puzzle
function SpyPuzzleSheriff1::onExit(%vertex)
{
   tsSendTaskClickDlg("ID_TASKNAME_SPYPUZZLE", "id_spypuzzle_sheriff",
      $TaskButton::Okay, "sheriff", "id_spypuzzle_sheriff");
   
   // set up the spy puzzle quest
   tsAddQuestToTracker(true, "Spy Games", "The Sheriff in town probably has some suggestions on where to start looking for the spy.",
      "One of the town's Civilians is working for the Mad Russian.  Two of the Civilians always tell the truth, while the other three are known to lie on occasion.  Determine which Civilian is the spy to find out the Mad Russian's whereabouts.", "Reward: 10 Experience");
   tsReadyQuest("Spy Games");
}

// after the rules have been read, update the data collected
function SpyPuzzleSheriff2::onExit(%vertex)
{
   // add the new task to the mission
   tsAddTaskToTracker("Spy Games", "Find the Mad Russian's spy.",
      "Use the clues available to determine which Civilian is spying for the Mad Russian.");
   
   // create the clue that the sheriff gave
   tsAddQuestToTracker(false, "Sheriff's Rules",
      tsGetTaskString("id_spypuzzle_sheriff"), "", "");
   tsReadyQuest("Sheriff's Rules");
}


// when a zone is entered, handle the zone message
function SpyPuzzleZone(%zone)
{
   // determine the message and the civilian to route
   // the message through
   %letter = "";
   %Messageletter = "";
   if (civA.isInZone(%zone)){
      %Messageletter = "Alpha";
      %letter = "a";
   }
   else if (civB.isInZone(%zone)){
      %Messageletter = "Beta";
      %letter = "b";
   }
   else if (civC.isInZone(%zone)){
      %Messageletter = "Cod";
      %letter = "c";
   }
   else if (civD.isInZone(%zone)){
      %Messageletter = "Delta";
      %letter = "d";
   }
   else
   {
      %Messageletter = "Ether";
      %letter = "e";
   }
   %message = "id_spypuzzle_message" @ %Messageletter;
   %accuse = "id_spypuzzle_accuse" @ %letter;
   %civilian = "civ" @ %letter;
   
   // send the task message for puzzle details
   tsSendTaskPopUpDlg("ID_TASKNAME_SPYPUZZLE", %message,
      $TaskButton::Okay, %civilian, %message);
   
   // send the task message used to accuse the civilian
   %dialog = tsCreateTaskDlgData("Saloon ID_TASKNAME_SPYPUZZLE", true,
      $TaskButton::Accept, %accuse);
   tsAddTaskDialog("id_spypuzzle_accusedialog", %dialog);
   tsSetAcceptButtonText("id_spypuzzle_accuseaccept", %dialog);
   tsSetCancelButtonText("id_spypuzzle_accusecancel", %dialog);
   tsSendTaskDlgMsg(%dialog, %civilian);
   tsDestroyTaskDlgData(%dialog);
   
   // add the clue to the quest list and unlock it
   tsAddQuestToTracker(false, getWord(%civilian.name, 0) @ "'s Clue",
      tsGetTaskString(%message), "", "");
   tsReadyQuest(getWord(%civilian.name, 0) @ "'s Clue");
}

// this helper function is called every time the wrong civilian is accused
function SpyPuzzleAccuseWrong(%civilian)
{
   // if the player has not been wrong before, this task should not
   // be marked completed
   if(SpyPuzzleWrong1.isComplete() == false &&
      SpyPuzzleWrong1.isMarkedComplete() == false)
   {
      // move civilian a near the sheriff's office and update
      // the rotation of the civilian to face forward
      %posX = getWord(accusept.position, 0);
      %posY = getWord(accusept.position, 1);
      %civilian.setPosition(%posX, %posY);
      %civilian.rotation = "0 0 1 24.0642";
      
      // send the "you picked wrong" message
      tsSendTaskClickDlg("ID_TASKNAME_SPYPUZZLE", "id_spypuzzle_accusewrong",
         $TaskButton::Okay, %civilian, "id_spypuzzle_accusewrong");

      TaskModifier.strMarkVertex("SpyPuzzle", "SpyPuzzleWrong1", $TSV_CMPLETE);
   }
   // otherwise, we have been wrong once before, and this will be the
   // end of the mission
   else
   {
      TaskModifier.strMarkVertex("SpyPuzzle", "SpyPuzzleWrong2", $TSV_CMPLETE);
   }
}

// this helper function is called every time the right civilian is accused
function SpyPuzzleAccuseRight(%civilian)
{
   // send the "you picked right" message
   tsSendTaskPopUpDlg("ID_TASKNAME_SPYPUZZLE", "id_spypuzzle_accuseright",
      $TaskButton::Okay, %civilian, "id_spypuzzle_accuseright");
   
   //Move Sheriff to Spy
   tsMoveObjToTarget("sheriff","civC");
   
   // notify the winning vertex
   TaskModifier.strMarkVertex("SpyPuzzle", "SpyPuzzleRight1", $TSV_CMPLETE);
}

// handling zone A message
function SpyPuzzleMessageA::onExit(%vertex)
{
   // handle zone A
   SpyPuzzleZone("civA");
}

// handling civilian A accusation
function SpyPuzzleAccuseA::onExit(%vertex)
{
   // wrong accusation
   SpyPuzzleAccuseWrong(civA);
}

// handling zone B message
function SpyPuzzleMessageB::onExit(%vertex)
{
   // handle zone B
   SpyPuzzleZone("civB");
}

// handling civilian A accusation
function SpyPuzzleAccuseB::onExit(%vertex)
{
   // wrong accusation
   SpyPuzzleAccuseWrong(civB);
}

// handling zone C message
function SpyPuzzleMessageC::onExit(%vertex)
{
   // handle zone C
   SpyPuzzleZone("civC");
}

// handling civilian C accusation
function SpyPuzzleAccuseC::onExit(%vertex)
{
   // wrong accusation
   SpyPuzzleAccuseRight(civC);
}

// handling zone D message
function SpyPuzzleMessageD::onExit(%vertex)
{
   // handle zone D
   SpyPuzzleZone("civD");
}

// handling civilian D accusation
function SpyPuzzleAccuseD::onExit(%vertex)
{
   // wrong accusation
   SpyPuzzleAccuseWrong(civD);
}

// handling zone E message
function SpyPuzzleMessageE::onExit(%vertex)
{
   // handle zone E
   SpyPuzzleZone("civE");
}

// handling civilian E accusation
function SpyPuzzleAccuseE::onExit(%vertex)
{
   // wrong accusation
   SpyPuzzleAccuseWrong(civE);
}

// if two civilians were incorrectly accused, end puzzle
function SpyPuzzleWrong2::onExit(%vertex)
{
   // give the restart options
   tsRestartScenario("id_spypuzzle_losedialog",
      "id_spypuzzle_restartbutton", "id_spypuzzle_quitbutton");
}

// if you guess correctly, get your reward
function SpyPuzzleRight1::onExit(%vertex)
{
   // complete the quest
   tsCompleteTaskInTracker("Spy Games", "Find the Mad Russian's spy.");
   
   // Sheriff Final Dialog
   tsSendTaskClickDlg("ID_TASKNAME_SPYPUZZLE", "id_spypuzzle_Sheriffaccept",
      $TaskButton::Okay, "sheriff", "id_spypuzzle_Sheriffaccept");
      
}

// mission is complete, return to the main map
function SpyPuzzleReturnWin::onExit(%vertex)
{
   // return from this satellite
   %scenario = new SLScenario()
   {
        stack = false;
   };
   LoadScenario(%scenario, EndSpyPuzzleTasks, winBanditSpyComplete);
   
   // complete the spy satellite
   mapsatellite_spy.disabled = false;
}

////////////////////////////////////////////////////////////////////////////////
//! Rewards the player if the task is successfully completed
////////////////////////////////////////////////////////////////////////////////
function winBanditSpyComplete()
{
   // experience reward for completing the quest
   tsModifyResource($Resource::Experience, 10, true);
   SendProductionToClient(HeroCharacter, "10 Experience");
   
   TaskModifier.strMarkVertex("MainmapTasks", "BanditSpyComplete", $TSV_AVAIL);
}
